#!/bin/bash
# Startup Script untuk Hosting - start.sh

echo "🚀 Starting Mas Angga WhatsApp Bot..."

# Set environment
export NODE_ENV=production

# Install dependencies jika diperlukan
if [ ! -d "node_modules" ]; then
    echo "📦 Installing dependencies..."
    npm install
fi

# Create .env jika belum ada
if [ ! -f ".env" ]; then
    echo "⚙️ Creating default .env file..."
    cat > .env << EOF
NODE_ENV=production
BOT_NAME=Mas Angga
PORT=3000
GROQ_API_KEY=
MAX_RETRIES=3
REQUEST_TIMEOUT=30000
MEMORY_LIMIT=512
EOF
    echo "✏️ Please edit .env file with your API keys"
fi

# Start with health monitoring
echo "🏃 Starting bot with health monitoring..."
node health-server.js &
HEALTH_PID=$!

sleep 2

echo "✅ Bot started successfully!"
echo "📱 Web interface: http://localhost:3000"
echo "⚙️ Configuration: http://localhost:3000/"
echo "📊 Health check: http://localhost:3000/health"

# Keep running
wait $HEALTH_PID
