@echo off
REM Startup Script untuk Windows - start.bat

echo 🚀 Starting Mas Angga WhatsApp Bot...

REM Set environment
set NODE_ENV=production

REM Install dependencies jika diperlukan
if not exist "node_modules" (
    echo 📦 Installing dependencies...
    npm install
)

REM Create .env jika belum ada
if not exist ".env" (
    echo ⚙️ Creating default .env file...
    (
        echo NODE_ENV=production
        echo BOT_NAME=Mas Angga
        echo PORT=3000
        echo GROQ_API_KEY=
        echo MAX_RETRIES=3
        echo REQUEST_TIMEOUT=30000
        echo MEMORY_LIMIT=512
    ) > .env
    echo ✏️ Please edit .env file with your API keys
)

REM Start with health monitoring
echo 🏃 Starting bot with health monitoring...
start /B node health-server.js

timeout /t 2 /nobreak > nul

echo ✅ Bot started successfully!
echo 📱 Web interface: http://localhost:3000
echo ⚙️ Configuration: http://localhost:3000/
echo 📊 Health check: http://localhost:3000/health

pause
