# 🏠 Setup Bot di Hosting Pribadi - LANGKAH MUDAH

## 🚀 Setup via Web Interface (TERMUDAH!)

### Step 1: Upload & Extract
1. Upload file `whatsapp-bot-mas-angga.zip` ke hosting
2. Extract di folder `/public_html/whatsapp-bot/`

### Step 2: Install Dependencies
```bash
# Login SSH
ssh username@yourdomain.com
cd public_html/whatsapp-bot

# Install packages
npm install --production
```

### Step 3: Setup via Web (NO COMMAND NEEDED!)
```bash
# Jalankan config server
npm run setup
```

**Lalu buka browser:** `http://yourdomain.com:8080`

### Step 4: Konfigurasi via Web
1. **Form akan terbuka** di browser
2. **Isi Groq API Key** (dapatkan gratis di console.groq.com)
3. **Klik 'Simpan Konfigurasi'**
4. **Klik 'Start Bot'** 
5. **Klik 'Lihat QR Code'** untuk scan di WhatsApp

**🎉 SELESAI! Bot langsung jalan 24/7**

---

## 📋 Alternative: Manual Setup

### 1. Cek Node.js Support
Login SSH dan ketik:
```bash
node --version    # Harus v16+
npm --version     # Harus ada
```

### 2. Upload File
Upload semua file dalam folder ini ke:
- **cPanel**: /public_html/whatsapp-bot/
- **VPS**: /var/www/whatsapp-bot/

### 3. Setup Environment (Manual)
```bash
# Copy template
cp .env.example .env

# Edit dengan API key Anda
nano .env
```

### 4. Install Dependencies
```bash
npm install --production
```

### 5. Start Bot
```bash
# Dengan PM2 (Recommended)
npm run pm2

# Atau manual
npm start
```

## 🌐 Setup Domain/Subdomain

### Option A: Subdomain (bot.domain.com)
1. cPanel → Subdomains
2. Create: bot.yourdomain.com
3. Document Root: /whatsapp-bot

### Option B: Folder (domain.com/bot)
1. Upload ke: /public_html/bot/
2. Akses: https://yourdomain.com/bot

## 📱 Akses Bot

- **QR Code**: https://bot.yourdomain.com/qr
- **Health Check**: https://bot.yourdomain.com/health
- **Dashboard**: https://bot.yourdomain.com/

## 🔧 Troubleshooting

### Bot tidak start:
```bash
npm install
node index-production.js
```

### QR Code tidak muncul:
1. Akses via web: /qr
2. Check logs: `pm2 logs`
3. Restart: `pm2 restart mas-angga-bot`

### Need Help?
Hubungi developer dengan error message lengkap.

---
🎉 **Bot siap digunakan 24/7 di hosting pribadi Anda!**
